'
' This class implements StreamingSensor operations for sensors made
' by Eagle.
'
Public Class EagleStreamingSensor
    Inherits EagleSimpleSensor
    Implements StreamingSensorImpl

    Private ssl As StreamingSensorListener
    Private freq As Integer

    '
    ' Streaming sensors produce a stream of measurement values.
    ' The value is the maximum number of times per minute that this
    ' streaming sensor will produce a measurement value.
    '   
    Public WriteOnly Property SamplingFrequency() As Integer _
     Implements StreamingSensorImpl.SamplingFrequency
        Set(ByVal value As Integer)
            freq = Value
        End Set
    End Property

    '
    ' This property is set by an object that represents the
    ' streaming sensor abstraction so that this object can perform a
    ' call-back to that object to deliver measurement values to it.
    ' The value is the abstraction object to deliver measurement values to.
    '
    Public WriteOnly Property StreamingSensorListener() _
     As StreamingSensorListener _
     Implements StreamingSensorImpl.StreamingSensorListener
        Set(ByVal value As StreamingSensorListener)
            ssl = CType(Value, StreamingSensorListener)
        End Set
    End Property
End Class 'EagleStreamingSensor 

